<?php

declare(strict_types=1);

namespace Dbp\Relay\CoreBundle\Authorization\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * This hook can be used to change the set of available attributes.
 *
 * You can extend the set, or remove attributes.
 */
class GetAvailableAttributesEvent extends Event
{
    /**
     * @var string[]
     */
    private $attributes;

    /**
     * @param string[] $attributes
     */
    public function __construct(array $attributes)
    {
        $this->attributes = $attributes;
    }

    /**
     * @param string[] $attributes
     */
    public function addAttributes(array $attributes): void
    {
        $this->attributes = array_merge($this->attributes, $attributes);
    }

    /**
     * @return string[]
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }
}
