#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
@author: imp
"""

file = './data.npz'

import numpy as np
import matplotlib.pyplot as plt
import pwelch_solv as ps

# load Data
loaded = np.load(file)
# sort Data
sinuses = loaded['sinuses']
noises = loaded['noises']
signal = loaded['signal']
weightedSignal = loaded['weightedSignal']


T = 10                          # 10 seconds sampling time
N_samples = len(sinuses[0])     # Nr of samples
fs = N_samples/T                # sample frequency
Ts = 1/fs                       # sample Period time

t = np.linspace(0, T,N_samples) # create time vector

# small snippet of data
idx =  np.linspace(0, (0.1/Ts),int(0.1/Ts)+1,dtype=int)

# Signal difference between ideal and weighted
delta = signal - weightedSignal

#prepare for pwelch solver
x = delta - np.mean(delta)
hwin = np.hanning(len(x))
N_overl = len(hwin)/2;

S = ps.func_pwelch(x, hwin, N_overl, fs)

plt.figure()
plt.semilogx(S['vfp'], S['LS'])
plt.xlabel('f in Hz')
plt.ylabel('LS in V')
plt.title('LS of delta')