#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Apr 14 13:07:56 2025

@author: imp
"""
import numpy as np

fs = 10000        # Sampling frequency
T = 10              # Sampling time
f = 50,60,70        # Frequencies
ampl = 1            # Amplitude of Signals
noise_pwr = 0.001  # White noise power
    
# create time vector
t = np.linspace(0, T,T*fs)

# generate sinosoidal signals
sinuses = ampl * np.sin(2 * np.pi * np.outer(f, t))

# generate different noises
noises = np.array([np.sqrt(noise_pwr) * np.random.randn(len(t)) for _ in f])

# generate noisy signals
noisy_singals = sinuses + noises
# create output Signal
outSignal = noisy_singals[0] + noisy_singals[1] + noisy_singals[2]
weightedOutSignal = 1.001*noisy_singals[0] + 1.003*noisy_singals[1] + 1.005*noisy_singals[2]

# Save data "ArrayName=DataVar"
np.savez_compressed('data.npz', sinuses=sinuses,noises=noises,signal=outSignal,
                    weightedSignal=weightedOutSignal)